#' Find leaf ID numbers for all leaves that are neighbours of a subspace, in the sense that they have non-negligible contributions to the integral of the density function
#' 
#' @param x numeric vector at which to search; any NA elements mean that any values are eligible in those dimensions
#' @param kudzu_list a kudzu list, such as kudzu::tree2kudzu() returns
#' @param proximity limit beyond which integral contributions are assumed negligible, called phi elsewhere
#' 
#' @return vector of natural numbers (integer class)
#' @export
#' 
#' @examples
#' neighbour_leaves(x=c(-0.1, 0, NA, 0),
#' 	             kudzu_list=iriskudzu,
#'               proximity=6)
neighbour_leaves <- function(x, kudzu_list, proximity){
	# move tops and bottoms
	adjusted_tops <- kudzu_list$tops + (proximity*kudzu_list$sigma)
	adjusted_bottoms <- kudzu_list$bottoms - (proximity*kudzu_list$sigma)

	# We can highjack the search_leaves() function for this. Note that 
	#   the contents of "densities" is not used in this function.
	return(search_leaves(x, stored_tree=list(tops=adjusted_tops,
		                                     bottoms=adjusted_bottoms,
		                                     densities=kudzu_list$heights)))
}
# American spelling version:
neighbor_leaves <- neighbour_leaves
