# binary (tree) search function


# examine a single node for membership
	# if node contains point, and is a leaf, return list(here=TRUE, child=NA)
	# if node contains point, and is not a leaf, and child with node ID 42
	# will contain the point, return list(here=FALSE, child=42)
search_node <- function(x,node) {
	# x is a numeric vector, the point to be sought
	# node should be an element of current_tree$nodes

	if(node$leaf) {
		return(list(here=TRUE, child=NA))
	} else{
		if(x[node$children_dimension]<node$children_cutpoint) {
			return(list(here=FALSE, child=node$children[1]))
		} else {
			return(list(here=FALSE, child=node$children[2]))
		}
	}
}

# this takes a current_tree list as input
	# returns the node ID of the leaf containing the point x
search_tree <- function(x,current_tree) {
	# check x is contained in bounding box
	if(any(current_tree$nodes[[1]]$tops<x) | any(current_tree$nodes[[1]]$bottoms>x)) {
		stop("x is not contained in tree's bounding box")
	}

	result <- search_node(x,current_tree$nodes[[1]])
	if(!result$here) {
		while(!result$here) {
			id <- result$child
			result <- search_node(x,current_tree$nodes[[id]])
		}
		return(id)
	} else {
		return(1)
	}
}


#' Obtain ID numbers of leaves of DET intersecting with given subspace
#' 
#' @param x numeric vector at which to find leaves; scan all values of any NA elements 
#' @param stored_tree a tree list, such as kudzu::tree() returns
#' 
#' @return vector of natural numbers (integer class)
#' @export
#' 
#' @examples
#' search_leaves(x=c(-0.1, NA, NA, 0),
#' 	             stored_tree=irisdet)
search_leaves <- function(x,stored_tree) {
	n_leaves <- length(stored_tree$densities)
	undertops <- apply(stored_tree$tops, 1, function(z){ all(z >= x , na.rm=TRUE) })
	overbottoms <- apply(stored_tree$bottoms, 1, function(z){ all(z <= x , na.rm=TRUE) })
	matches <- undertops & overbottoms
	if(!any(matches)) { 
		stop("x is not contained in tree's bounding box")
	} else {
		return(which(matches)) 
		# is it more useful to have a numeric vector of IDs or a boolean vector?
	}
}


