% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbour_leaves.R
\name{neighbour_leaves}
\alias{neighbour_leaves}
\title{Find leaf ID numbers for all leaves that are neighbours of a subspace, in the sense that they have non-negligible contributions to the integral of the density function}
\usage{
neighbour_leaves(x, kudzu_list, proximity)
}
\arguments{
\item{x}{numeric vector at which to search; any NA elements mean that any values are eligible in those dimensions}

\item{kudzu_list}{a kudzu list, such as kudzu::tree2kudzu() returns}

\item{proximity}{limit beyond which integral contributions are assumed negligible, called phi elsewhere}
}
\value{
vector of natural numbers (integer class)
}
\description{
Find leaf ID numbers for all leaves that are neighbours of a subspace, in the sense that they have non-negligible contributions to the integral of the density function
}
\examples{
neighbour_leaves(x=c(-0.1, 0, NA, 0),
	             kudzu_list=iriskudzu,
              proximity=6)
}
