% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{normalise}
\alias{normalise}
\title{Transform data to means of 0, standard deviations of 1 and zero Pearson correlations}
\usage{
normalise(data, center = TRUE, scale = TRUE, rotate = TRUE)
}
\arguments{
\item{data}{matrix with observations in rows and variables in columns (float or integer; defined on a metric space)}

\item{center}{Boolean: whether to set means to 0; default TRUE}

\item{scale}{Boolean: whether to set standard deviations to 1; default TRUE}

\item{rotate}{Boolean: whether to set Pearson correlations to 0 (by eigenvector decomposition); default TRUE}
}
\value{
matrix of dimensions dim(data)
}
\description{
Transform data to means of 0, standard deviations of 1 and zero Pearson correlations
}
\examples{
normiris <- normalise(data=iris)
}
