% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{tree}
\alias{tree}
\title{Create a density estimation tree}
\usage{
tree(data, goal, grow_parameters, prune_parameters, dep_var, full_tree = FALSE)
}
\arguments{
\item{data}{matrix with observations in rows and variables in columns (float or integer; defined on a metric space)}

\item{goal}{"density" is the only valid option at present; later, "classify" and "regress" will be added to make a general-purpose CART++, and it might accept a user-specified loss function}

\item{grow_parameters}{a list of parameters controlling growth: min_n_l (natural number, minimum number of observations per node) and max_nodes (natural number, maximum number of nodes -- not necessarily leaves) are the only ones in use at present; set it to anything not a list (canonically, NA_integer_) to prevent growth (and pruning)}

\item{prune_parameters}{not in use yet; set it to anything not a list (canonically, NA_integer_) to prevent pruning}

\item{dep_var}{not in use yet, so set it to something small like NA_integer_; later, it will be a numeric vector of length NROW(data) containing a dependent variable}

\item{full_tree}{Boolean: whether to return a large list of metadata and all nodes; defalut is FALSE}
}
\value{
a list containing a matrix of leaf tops, a matrix of leaf bottoms, a vector of leaf densities
}
\description{
Create a density estimation tree
}
\examples{
irisdet <- tree(data=as.matrix(iris[,-5]),
	             goal="density",
	             grow_parameters=list(min_n_l=5, max_nodes=100),
	             prune_parameters=NA_integer_,
	             dep_var=NA_integer_)
}
