% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree2kudzu.R
\name{tree2kudzu}
\alias{tree2kudzu}
\title{Adjust DET leaf height so a kudzu density function will integrate to one given a bandwidth, and export a kudzu list}
\usage{
tree2kudzu(stored_tree, sigma, phi)
}
\arguments{
\item{stored_tree}{a tree list, such as kudzu::tree() returns}

\item{sigma}{a positive real number, the bandwidth of the inverse logistic ramp, larger sigma means more smoothing}

\item{phi}{a multiple of sigma, beyond which we regard the inverse logistic ramps as having negligible area under the curve; we use 6}
}
\value{
a list specifying the kudzu density, containing a "tops" matrix, a "bottoms" matrix, a "heights" vector, "sigma", an "eb" matrix of exponentials of scaled bottoms, "et" likewise for tops, and "kudzu_version", a natural number for future back-compatibility
}
\description{
Adjust DET leaf height so a kudzu density function will integrate to one given a bandwidth, and export a kudzu list
}
\examples{
irisdet <- tree(data=iris,
	             goal="density",
	             grow_parameters=list(min_n_l=5, max_nodes=100),
	             prune_parameters=NA_integer_,
	             dep_var=NA_integer_)
iriskudzu <- tree2kudzu(stored_tree=irisdet,
	             sigma=0.1,
	             phi=6)
}
