cd "~/Dropbox/Books/Dataviz CRC-ASA/images"

import delimited using gistemp.csv, delimiter(",") rowrange(2:) varnames(2) clear
foreach v of varlist oct-dec {
	replace `v'="" if `v'=="***"
	destring `v', replace
}
keep year-dec
local monthnum 1
foreach v of varlist jan-dec {
	rename `v' temp`monthnum'
	local ++monthnum
}
reshape long temp, i(year) j(month) 
keep if year>1973
drop in 1/9
gen index=_n
line temp index, graphregion(color(white)) ytitle("") xtitle("") ///
				xlabel(none) xline(46) xline(55) xline(66) xline(94) ///
				xline(115) xline(209) xline(252) xline(385) xline(413) ///
				ysize(5) xsize(15)
graph save gistemp.gph, replace
graph export gistemp.svg, replace
graph export gistemp.png, replace
