#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <termios.h>
#include <unistd.h>
#include <iomanip>
#include <sys/stat.h>
using std::ios;
using std::cin;
using std::cout;
using std::cerr;
using std::endl;
using std::string;
using std::ifstream;
using std::ofstream;
using std::stringstream;
using std::ios_base;

/* permitted args:
   input_file code_file output_file startbyte [-h|--hex]
	 input_file output_file -s|--secret [-h|--hex]
*/
int main(int argc, char *argv[]) {
	// get arguments
	if(argc<4) {
	    cerr << "Arguments missing: should be input file, then coding file, then output file, OR input file, then output file, then -s or --secret. Additionally, you can specify -h or --hex for big endian hexadecimal representation." << endl;
	    return -1;
	}
	stringstream sarg;
	string tempfiles[3]; // holds filenames until allocated
	string argvstring;
	int filecount = 0;
	string infile;
	string incode;
	string outfile;
	int startcode;
	bool secretflag = false;
	bool hexflag = false;

	// allocate args to variables
	for(int i=1; i<argc; ++i) {
		sarg << argv[i];
		argvstring << sarg;
		if(argvstring=="-s" || argvstring=="--secret") {
			secretflag = true;
		}
		else if(argvstring=="-h" || argvstring=="--hex") {
			hexflag = true;
		}
		else {
			startcode << sarg;
			if(!startcode) {
				tempfiles[filecount] = argv[i];
				++filecount
			}
		}
	}
	if(secretflag) {
		infile = tempfiles[0];
		outfile = tempfiles[1];
	}
	else {
		infile = tempfiles[0];
		incode = tempfiles[1];
		outfile = tempfiles[2];
	}
//int x = boost::lexical_cast<int>("12345"); 


	// hidden input if secret:
	if(secretflag) {
		// get code file
		string codecin;
		string startcin;
		cout << "Coding file:" << endl;
    termios oldt;
    tcgetattr(STDIN_FILENO, &oldt);
    termios newt = oldt;
    newt.c_lflag &= ~ECHO;
    tcsetattr(STDIN_FILENO, TCSANOW, &newt);
		getline(cin,codecin);
		if(codecin.length() > 0) {
			stringstream(codecin) >> incode;
		}
		else {
			cerr << "Error! No code file has been specified." << endl;
			return -2;
		}
		tcsetattr(STDIN_FILENO, TCSANOW, &oldt);
		// get start byte
		cout << "Coding file start byte:" << endl;
    tcsetattr(STDIN_FILENO, TCSANOW, &newt);
		getline(cin,startcin);
		if(startcin.length() > 0) {
			stringstream(startcin) >> startcode;
		}
		else {
			cout << "Warning! No start byte has been specified." << endl;
			cout << "Coding will start at the beginning of the code file, which may be vulnerable to attack because of predictable metadata." << endl;
		}
		tcsetattr(STDIN_FILENO, TCSANOW, &oldt);
	}

	// get infile size
	int insize=0;
  ifstream inst;
  inst.open(infile, ios_base::binary);
  inst.seekg(0,ios_base::end);
  insize = inst.tellg();
	inst.seekg(0,ios_base::beg);

	// get codefile size
	int codesize=0;
  ifstream codest;
  codest.open(incode, ios_base::binary);
  codest.seekg(0,ios_base::end);
  codesize = codest.tellg();

	// check codesize>=insize
	codesize = codesize - startcode;
  codest.seekg(startcode,ios_base::beg);
	if (codesize < insize) {
		cerr << "Error! The coding file (from the start point) is smaller than the input file." << endl;
		cout << "Input file length: " << insize << " bytes" << endl;
		cout << "Coding file length: " << codesize << " bytes" << endl;

	}

	// xor and write
	ofstream outst;
	outst.open(outfile, ios::out | ios::binary);
	char inbuff[1];
	char inchar;
	int inbytes;
	int codebytes;
	char codebuff[1];
	char codechar;
	string outstring;
	char outchar;
	char outbuff[1];
	int inint;
	int codeint;
	int outint;
	stringstream outstream;
	if(inst) {
	        while(true) {
							inst.read(inbuff, 1);
							if(inst.eof()) {
								break;
							}
							inchar = inbuff[0];
							inint = (char)inchar;
							inbytes = inst.gcount(); 	// get number of bytes read from infile
							if(!codest) {
									cerr << "Error when attempting to read from the coding file" << endl;
									return -3;
							}
							else {
									codest.read(codebuff, 1);
									codechar = codebuff[0];
									codeint = (char)codechar;
									codebytes = codest.gcount(); 	// get number of bytes read from codefile
									outint = inint ^ codeint; // <--  this is the XOR
									if(hexflag) {
										outstring << outstream << std::setw(2) << std::setfill('0') << (int)outint;
										outst.write(outstring, 2);
									}
									else {
										outchar = (int)outint;
										outbuff[0] = outchar;
										outst.write(outbuff, 1);
									}
							}
					}
	}
	else {
		  cerr << "Error when attempting to read from the input file" << endl;
			return -4;
  }

	// tidy up
	inst.close();
	codest.close();
	outst.close();
	return 0;
}
